/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CInternetSocket.h,v 1.2 1999/10/26 02:03:54 jason Exp $
____________________________________________________________________________*/

#pragma once 

#include "CSocket.h"


class CInternetSocket : public CSocket {
public:
							CInternetSocket();
	virtual 				~CInternetSocket();

	virtual void			Bind(const PGPSocketAddressInternet *
									inAddress);
	virtual void			Close();
	
	virtual void			GetSocketName(PGPSocketAddressInternet * outName);

	virtual void			IOControlSocket(SInt32 inCommand,
								UInt32 * ioParam);

protected:
	EndpointRef				mEndpointRef;
	InetAddress				mBoundAddress;
	Boolean					mCanceled;
	
	virtual void			Cleanup();
	virtual void			DoBind(OTQLen inQLen);
	
	virtual Boolean			IsReadable();
	virtual Boolean			IsWriteable();
	virtual Boolean			IsError();

	virtual void			ThrowIfOTError(OSStatus inErr);
	
	static pascal void		NotifyProc(void* contextPtr, OTEventCode code, 
									   OTResult result, void* cookie);
};